﻿/*
VERSION:	1.1

DECRIPTION:
	This system is meant to be used with the  walkInertia.as  style of movement.
	It collides with tiles on the map.

AVAILABLE DATA:
	This returns a collision function which changes its parent's objects & properties.
	The parent collision system (this) contains:
		xOffset, yOffset
		player_mc
			_x, _y
		collision_array
		walk_obj
			xVel, yVel
	
*/
function makeTileCollision( walk_obj, wallValues )
{
	walk_obj.wallValues = wallValues;
	var collision_funct = function()
	{
		if(this.walk_obj.wallValues)
			this.walk_obj.wallValues = [1];
		// define size
		var size = 5;		// 5 pixels in all directions
		
		// extract velocities
		var xVel = this.walk_obj.xVel;
		var yVel = this.walk_obj.yVel;
		
		// horz
		// get direction
		var xDir = Math.abs(xVel) / xVel;
		// make top-right OR top-left point  +  velocity	(map-relative)	(top)
		var xTop = this.player_mc._x + (size*xDir) + xVel + this.xOffset;
		var yTop = this.player_mc._y - size + this.yOffset;
		// store collision ID of top-right point
		var xTopTile = Math.floor(xTop / 16);
		var yTopTile = Math.floor(yTop / 16);
		var topCollision = this.collision_array[xTopTile][yTopTile];
		// make bottom-right OR bottom-left point  +  velocity	(map-relative)	(bottom)
		var xBottom = this.player_mc._x + (size*xDir) + xVel + this.xOffset;
		var yBottom = this.player_mc._y + size + this.yOffset;
		// store collision ID of bottom-right point
		var xBottomTile = Math.floor(xBottom / 16);
		var yBottomTile = Math.floor(yBottom / 16);
		var bottomCollision = this.collision_array[xBottomTile][yBottomTile];
		// if top or bottom point collided
		var horzCollision = false;
		for(var nam in this.walk_obj.wallValues)
			if(topCollision==this.walk_obj.wallValues[nam]  ||  bottomCollision==this.walk_obj.wallValues[nam])
				horzCollision = true;
		if( horzCollision )
		{// if:  A horz point collided
			// reset horz velocity
			this.walk_obj.xVel = 0;
		}// if:  A horz point collided
		
		
		// vert
		// get direction
		var yDir = Math.abs(yVel) / yVel;
		// make left-top OR left-bottom point  +  velocity	(map-relative)	(left)
		var xLeft = this.player_mc._x - size + this.xOffset;
		var yLeft = this.player_mc._y + (size*yDir) + yVel + this.yOffset;
		// store collision ID of left-top point
		var xLeftTile = Math.floor(xLeft / 16);
		var yLeftTile = Math.floor(yLeft / 16);
		var leftCollision = this.collision_array[xLeftTile][yLeftTile];
		// make right-top OR right-bottom point  +  velocity	(map-relative)	(right)
		var xRight = this.player_mc._x + size + this.xOffset;
		var yRight = this.player_mc._y + (size*yDir) + yVel + this.yOffset;
		// store collision ID of right-top point
		var xRightTile = Math.floor(xRight / 16);
		var yRightTile = Math.floor(yRight / 16);
		var rightCollision = this.collision_array[xRightTile][yRightTile];
		// if left or right collided
		var vertCollision = false;
		for(var nam in this.walk_obj.wallValues)
			if(leftCollision==this.walk_obj.wallValues[nam]  ||  rightCollision==this.walk_obj.wallValues[nam])
				vertCollision = true;
		if( vertCollision )
		{// if:  A vert point collided
			// reset horz velocity
			this.walk_obj.yVel = 0;
		}// if:  A vert point collided
	}// collision_funct()
	
	return collision_funct;
}// makeTileCollision()